class UniversalSoldiersPickup extends Pickup;

var int LifeTime;
var string Claimer;

function FireEffect();

event float BotDesireability(Pawn Bot)
{
	return (0); 
}


function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
}

function BecomeItem()
{
	local Bot B;
	local Pawn P;

	Super.BecomeItem();

	if ( Instigator.IsA('Bot') || Level.Game.bTeamGame || !Level.Game.IsA('DeathMatchPlus')
		|| DeathMatchPlus(Level.Game).bNoviceMode
		|| (DeathMatchPlus(Level.Game).NumBots > 4) )
		return;

	// let high skill bots hear pickup if close enough
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		B = Bot(p);
		if ( (B != None)
			&& (VSize(B.Location - Instigator.Location) < 800 + 100 * B.Skill) )
		{
			B.HearPickup(Instigator);
			return;
		}
	}
}

defaultproperties
{
     M_Activated=""
     M_Selected=""
     M_Deactivated=""
     PickupMessageClass=Class'Botpack.PickupMessagePlus'
     ItemMessageClass=Class'Botpack.ItemMessagePlus'
     bClientAnim=True
     LifeTime=45
}
